#include <xc.h>
#include "main_header.h"

void init_Calibration(void)
{
    PMCON1bits.CALSEL = 1;  // select the Calibration section erea.
    PMADRH = 0x20;          // CAUTION!
    PMADRL = 0x80;          // point Calibration word_1

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    DCSCAL = (PMDATL & 0x7F);   // write DCSCAL using DCSRFB internal fedback


    PMADRL = 0x81;          // point Calibration word_2

    PMCON1bits.RD = 1;      // Initiate Read
    NOP();
    NOP();
    DSTCAL = (PMDATH & 0x1F);   // write DSTCAL
    RFBTCAL = (PMDATL & 0x3F);  // write RFBTCAL

    PMADRL = 0x82;              // point to Calibration word_3

    PMCON1bits.RD = 1;      // Initiate Read
    NOP();
    NOP();
    BGRCAL = (PMDATL & 0x1F);   // write BGRCAL

    PMADRL = 0x83;              // point Calibration word_4

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    TTACAL = (PMDATL & 0x0F);   // write TTACAL

// point Calibration word_6
    PMADRL = 0x85;              // point Calibration word_6

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    OSCCAL = (PMDATL & 0x7F);   // write OSCCAL

// point Calibration word_7
//    PMADRL = 0x86;              // point Calibration word_7
//
//    PMCON1bits.RD = 1;          // Initiate Read
//    NOP();
//    NOP();
//    DCSCAL = (PMDATL & 0x7F);   // write DCSCAL using ISOUT external

// point Calibration word_8
    PMADRL = 0x87;              // point Calibration word_8

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    EAOFFCAL = (PMDATL & 0x1F);   // write EA OFFSET CAL
    A2GCAL = (PMDATH & 0x0F);     // write A2Gain using internal

    PMADRL = 0x88;               // point Calibration word_9

    PMCON1bits.RD = 1;           // Initiate Read
    NOP();
    NOP();
    OVRSPCAL = (PMDATH & 0x1F);   // write OVREF Span CAL
    //A2GCAL = (PMDATL & 0x0F);    // write A2Gain using external

    PMADRL = 0x89;              // point Calibration word_10

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    VR2SPCAL = (PMDATH & 0x1F);   // write VREF2 Span CAL
    VRSPCAL = (PMDATL & 0x1F);    // write VREF Span CAL

    PMADRL = 0x8A;              // point Calibration word_11

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    AVDDCAL = (PMDATH & 0x0F);   // write AVDD CAL


    PMADRL = 0x8C;              // point Calibration word_13

    PMCON1bits.RD = 1;          // Initiate Read
    NOP();
    NOP();
    ADCC = PMDATL | (PMDATH << 8);

    //write DSCCAL External Feedback resistor
    //PMADRL = 0x86
    //PMCON1bits.RD = 1;          // Initiate Read
    //NOP();
    //NOP();
    //DCSCAL = (PMDATH & 0x3F); //

    PMCON1bits.CALSEL = 0;      // Read user selected area
}

void init_SFR(void)
{

// SFR Initialization
// Bank 0
    INTCON      = 0x00;
    T1CON       = 0x00;  
    T2CON       = 0x00;       // Disable Timer2
    PIR1        = 0x00;
    PIR2        = 0x00;
    TMR1L       = 0x00;
    TMR1H       = 0x00;
    VREFCON     = 0x00;
    VREF2CON    = 0x00;
    OSCTUNE     = 0x00;
    PORTGPA     = 0x00;       // Clear Port GPAs
    PORTGPB     = 0x00;       // Clear Port GPBs


// Bank 1
    OPTION_REG       = 0x83;       // (0x87) pull-ups disabled, TMR0 1:16 Prescale
    VINUVLO     = 0x0C;       // (0x0C) UVLO = 5V
    VINOVLO     = 0x29;       // (0x29) OVLO = 24V
    CC1RL       = 0x00;
    CC1RH       = 0x00;
    CC2RL       = 0x00;
    CC2RH       = 0x00;
    CCDCON      = 0x00;
    DESATCON    = 0x00;
    VINCON      = 0x00;       // Clear VIN UVLO  / VIN OVLO
    OVCON       = 0x00;       // Clear OVCON
    VREFCON     = 0x00;       // Clear VREF
    OVREFCON    = 0x00;       // Clear OV
    DEADCON     = 0xF7;       // (0xF7) Dead Time initial
    SLPCRCON    = 0x29;       // (0x29) EN
    ICOACON     = 0x00;       // (0) No input current offset
    ICLEBCON    = 0x03;       // (0x03) Leading edge blanking = 200ns
    PIE1             = 0x00;       // Clear PIE1
    PIE1bits.TMR1IE  = 1;     // TMR1 interrupt enabled
    PIE1bits.SSPIE   = 1;     // Synchronous Serial Port (MSSP) Interrupt Enable
    PIE2bits.OVIE    = 1 ;    // Enable OVLO interrupt
    PIE2             = 0x00;
    PIE2bits.OVLOIE  = 1;     // Enable VINOVLO interrupt
    PIE2bits.UVLOIE  = 1;     // Enable VINUNLO interrupt
    ABECONbits.EADIS = 1;     // 1 Disable Error Amplifier / 0 Enable
    INTCONbits.PEIE  = 1;     // Peripheral Interrupt Enable bit
    INTCONbits.GIE   = 1;     // Global Interrupt Enable
    
// Bank 2
    WPUGPA      = 0x00;
    WPUGPB      = 0x00;
    PE1         = 0x00;
    ABECON      = 0x00;
    //MODECON     = 0x00;

// Bank 3
    IOCA        = 0x00;
    IOCB        = 0x00;
    PMCON1      = 0x00;
//    ATSTCON     = 0x00;
}


void init_Periphrials(void)
{
    unsigned char   temp;

// Periphrial Initialization
// General Purpose Port
    PORTGPA     = 0x00;
    PORTGPB     = 0x00;
    TRISGPA     = 0x80;
    TRISGPB     = 0x01;
    ANSELA      = 0x00;
    ANSELB      = 0x00;

    
// PWM
    T2CON       = 0x00;
    PR2         = 0x4F;     // (0x4F) SW Freq is 100kHz
    PWMPHL      = 0x00;     // (0) No Phase Shift
    PWMPHH      = 0x00;     // (0) No Phase Shift
    PWMRL       = 0x02;     // (0x02) Max Duty is 2.5% for 100 kHz
    PWMRH       = 0x02;     // (0x02) Max Duty is 2.5% for 100 kHz

// ADC
    ADCON0      = 0x19;
    ADCON1      = 0x50;

// I2C
    SSPADD      = 0xB8;
    temp        = SSPBUF;
    SSPSTAT     = 0x00;
    SSPCON2     = 0x00;
    SSPCON3     = 0x00;
    SSPMSK      = 0xFC;     // bit1 not used to detect I2C address match
    SSPCON1     = 0x36;
}


